/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GenericDataPoint;
import ibm.nways.analysis.dpCommon.HistoryEvent;
import ibm.nways.analysis.dpCommon.MultiDataPoint;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.StandardDeviation;
import ibm.nways.analysis.dpEngine.AbstractResult;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpPollingDefinition;
import ibm.nways.analysis.dpEngine.DpPollingInstance;
import ibm.nways.analysis.dpEngine.Expression;
import ibm.nways.analysis.dpEngine.IllegalInsertException;
import ibm.nways.analysis.dpEngine.InvalidExpressionException;
import ibm.nways.analysis.dpEngine.MismatchRowNode;
import ibm.nways.analysis.dpEngine.MultiResult;
import ibm.nways.analysis.dpEngine.NeedInsertException;
import ibm.nways.analysis.dpEngine.NodeAndCount;
import ibm.nways.analysis.dpEngine.OiList;
import ibm.nways.analysis.dpEngine.Result;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.snmp.AbstractSnmpPoller;
import ibm.nways.jdm.snmp.PollingAction;
import ibm.nways.jdm.snmp.PollingFilter;
import ibm.nways.jdm.snmp.PollingInterval;
import ibm.nways.jdm.snmp.PollingPreFilter;
import ibm.nways.jdm.snmp.SnmpPoller;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.TableHandler;
import ibm.nways.jdm.snmp.TablePoller;
import ibm.nways.jdm.snmp.TablePollingAction;
import ibm.nways.jdm.snmp.TablePollingFilter;
import ibm.nways.jdm.snmp.TablePollingPreFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DpNode
implements Serializable {
    private static Hashtable emptyHashTable = new Hashtable();
    private long id = -1L;
    protected DpPollingInstance pollingInst;
    protected NotifyObject armStuff;
    private boolean armed;
    protected SnmpSession session;
    protected OiList oiList;
    protected Expression[] expressionList;
    protected SnmpPoller scalarPoller;
    protected TablePoller tablePoller;
    private GenericDataPoint[] theDataPoints;
    protected Object[] oldValues;
    protected Object[] newValues;
    protected int baseLength;
    private int historySize;
    private int newHistorySize;
    private boolean historyOverflowNotified = false;
    private int oldestNeededFile = -1;
    private float autoThresholdLevel = 1.2f;
    private StandardDeviation sdev;
    private float poppedValue;
    private int numIntervals;
    private static int minimumAutoSamples = 5;
    private String fileName;
    private int currentFile;
    private int internalOffset = 0;
    private long numValues;
    private long invalidValues;
    private long consecutiveInvalidValues;
    private boolean isPolling = false;
    private int maxFiles = 10;
    private boolean noRedShift;
    private int numExpressions;
    protected Vector rows;
    private String defaultID;
    private String state;
    Hashtable states = new Hashtable();

    protected boolean getNoRedShift() {
        return this.noRedShift;
    }

    protected boolean isPolling() {
        return this.isPolling;
    }

    protected String getIpAddress() {
        return this.session.getIpAddress();
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected Object[] getOldValues() {
        return this.oldValues;
    }

    protected Object[] getNewValues() {
        return this.newValues;
    }

    protected synchronized void arm() {
        this.armed = true;
    }

    protected synchronized void disarm() {
        this.armed = false;
    }

    protected synchronized boolean isarmed() {
        return this.armed;
    }

    protected long getId() {
        return this.id;
    }

    protected String getCommunityName() {
        return this.session.getCommName();
    }

    protected NodeAndCount getSession() {
        return this.pollingInst.getSession();
    }

    protected void changeHistorySize(int n) {
        this.newHistorySize = n;
    }

    protected void setAutoThresholdLevel(float f) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("modifying auto level to : " + f);
        }
        this.autoThresholdLevel = f;
    }

    protected NotifyObject getNotifyObject() {
        if (this.armStuff == null) {
            return this.pollingInst.getPollingDefinition().getPollingObjectDefinition().getNotifyObject();
        }
        return this.armStuff;
    }

    protected DpNode(DpPollingInstance dpPollingInstance, long l, boolean bl) {
        this.noRedShift = bl;
        this.id = l;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("   Completed node Constructor");
        }
        this.rows = new Vector();
        this.sdev = new StandardDeviation(20);
        this.states.put("Normal", this.sdev);
        this.state = "Normal";
        this.pollingInst = dpPollingInstance;
    }

    protected boolean initialize(DpPollingInstance dpPollingInstance, SnmpPoller snmpPoller, TablePoller tablePoller, SnmpSession snmpSession, NotifyObject notifyObject) {
        return this.initialize(dpPollingInstance, snmpPoller, tablePoller, snmpSession, null, notifyObject, null);
    }

    protected boolean initialize(DpPollingInstance dpPollingInstance, SnmpPoller snmpPoller, TablePoller tablePoller, SnmpSession snmpSession, Hashtable hashtable, NotifyObject notifyObject, DataPoint[] dataPointArray) {
        boolean bl = true;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("   DpNode:Initializing node  " + dpPollingInstance.getHostname());
        }
        if (snmpSession != null) {
            int n;
            String string;
            Object object;
            Object object2;
            Object object3;
            block45: {
                DpPollingDefinition dpPollingDefinition = dpPollingInstance.getPollingDefinition();
                this.pollingInst = dpPollingInstance;
                this.oiList = this.pollingInst.getPollingDefinition().getOiList();
                if (this.oiList == null && hashtable == null) {
                    hashtable = emptyHashTable;
                }
                if (this.oiList == null && hashtable != null) {
                    if (DpInterfaceImpl.trace) {
                        DpInterfaceImpl.LogMessage("   DpNode:Resolutions required");
                    }
                    object3 = dpPollingDefinition.getPollingObjectDefinition().getExpression();
                    try {
                        this.oiList = new OiList((String)object3);
                        object2 = new StringTokenizer((String)object3, ",");
                        this.expressionList = new Expression[((StringTokenizer)object2).countTokens()];
                        int n2 = 0;
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            this.expressionList[n2] = new Expression(((StringTokenizer)object2).nextToken(), this.oiList, hashtable);
                            if (this.defaultID == null && this.expressionList[n2].defaultIndex != null) {
                                this.defaultID = this.expressionList[n2].defaultIndex;
                                this.expressionList[n2].defaultIndex = null;
                            }
                            ++n2;
                        }
                        this.oiList.setWildcardVsScalar();
                        if (DpInterfaceImpl.trace) {
                            DpInterfaceImpl.LogMessage("   DpNode:Expressions built");
                        }
                        object = new PollingInterval(dpPollingDefinition.getPollingObjectDefinition().getNotifyObject().getPollingInterval() * 1000);
                        DpInterfaceImpl.modifyHeartbeatTimeout(((PollingInterval)object).interval);
                        if (this.oiList.getScalarOIcount() != 0 && !(this instanceof MismatchRowNode)) {
                            snmpPoller = new SnmpPoller((PollingInterval)object, this.oiList.getScalarOIs(), true, (PollingAction)dpPollingDefinition, (PollingFilter)dpPollingDefinition, (PollingPreFilter)dpPollingDefinition);
                            if (DpInterfaceImpl.trace) {
                                DpInterfaceImpl.LogMessage("   DpNode:Adding Scalar Poller:" + snmpPoller.toString());
                            }
                        }
                        if (this.oiList.getWildcardOIcount() == 0) break block45;
                        tablePoller = new TablePoller((PollingInterval)object, this.oiList.getWildcardOIs(), null, true, (TableHandler)dpPollingDefinition, (TablePollingAction)dpPollingDefinition, (TablePollingFilter)dpPollingDefinition, (TablePollingPreFilter)dpPollingDefinition);
                        if (DpInterfaceImpl.trace) {
                            DpInterfaceImpl.LogMessage("   DpNode:Adding Table Poller:" + tablePoller.toString());
                        }
                    }
                    catch (NeedInsertException needInsertException) {
                        this.oiList = null;
                        this.expressionList = null;
                        DpInterfaceImpl.LogMessage("DpNode:Insert not resolved:" + needInsertException);
                    }
                    catch (IllegalInsertException illegalInsertException) {
                        this.oiList = null;
                        this.expressionList = null;
                        DpInterfaceImpl.LogMessage("DpNode:Illegal insert:" + illegalInsertException);
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        this.oiList = null;
                        this.expressionList = null;
                        DpInterfaceImpl.LogMessage("DpNode:" + invalidExpressionException);
                    }
                } else {
                    if (this.oiList == null) {
                        if (DpInterfaceImpl.trace) {
                            DpInterfaceImpl.LogMessage("   DpNode:Resolutions not available for inserts");
                        }
                        return false;
                    }
                    if (DpInterfaceImpl.trace) {
                        DpInterfaceImpl.LogMessage("   DpNode:Using basic expressions");
                    }
                    this.expressionList = dpPollingDefinition.expressionList;
                    this.oiList = dpPollingDefinition.oiList;
                    snmpPoller = dpPollingDefinition.scalarPoller;
                    tablePoller = dpPollingDefinition.tablePoller;
                }
            }
            if (this.oiList == null) {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("   DpNode:No OI List available");
                }
                return false;
            }
            this.oldValues = new Object[this.oiList.getOIcount()];
            this.newValues = new Object[this.oiList.getOIcount()];
            if (this.expressionList == null) {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("   DpNode:No Expressions available");
                }
                return false;
            }
            this.armed = false;
            this.armStuff = notifyObject;
            if (notifyObject != null) {
                string = String.valueOf(notifyObject.getIdentifier()) + this.id;
                n = notifyObject.getPollingInterval();
            } else {
                string = String.valueOf(this.pollingInst.getPollingDefinition().getPollingObjectDefinition().getNotifyObject().getIdentifier()) + this.id;
                n = this.pollingInst.getPollingDefinition().getPollingObjectDefinition().getNotifyObject().getPollingInterval();
            }
            this.numExpressions = this.expressionList.length;
            if (this.getNotifyObject().getWhenToNotify() != 5) {
                block46: {
                    int n3;
                    this.historySize = !DpInterfaceImpl.writeToFile ? DpInterfaceImpl.historySize : DpInterfaceImpl.historySize / this.maxFiles;
                    if (this.expressionList.length == 1) {
                        this.theDataPoints = new DataPoint[this.historySize];
                        n3 = 0;
                        while (n3 < this.historySize) {
                            this.theDataPoints[n3] = new DataPoint();
                            ++n3;
                        }
                    } else {
                        this.theDataPoints = new MultiDataPoint[this.historySize];
                        n3 = 0;
                        while (n3 < this.historySize) {
                            this.theDataPoints[n3] = new MultiDataPoint();
                            ++n3;
                        }
                    }
                    minimumAutoSamples = DpInterfaceImpl.validSampleInterval / n;
                    if (minimumAutoSamples < 2) {
                        minimumAutoSamples = 2;
                    }
                    object3 = System.getProperty("file.separator");
                    object2 = new String(String.valueOf(DpInterfaceImpl.dataRoot) + (String)object3 + this.pollingInst.getPollingDefinition().getPollingObjectDefinition().getIdentifier() + (String)object3 + this.pollingInst.getHostname());
                    File file = new File((String)object2);
                    file.mkdirs();
                    file = null;
                    this.fileName = new String(String.valueOf(object2) + (String)object3 + string);
                    object2 = null;
                    if (DpInterfaceImpl.trace) {
                        DpInterfaceImpl.LogMessage("   Initializing node  set file info");
                    }
                    try {
                        object = new File(String.valueOf(this.fileName) + ".0");
                        if (((File)object).exists()) {
                            if (DpInterfaceImpl.trace) {
                                DpInterfaceImpl.LogMessage("   starting to reload history");
                            }
                            this.reloadHistory();
                            if (DpInterfaceImpl.trace) {
                                DpInterfaceImpl.LogMessage("   completed reload history");
                            }
                            break block46;
                        }
                        throw new IOException();
                    }
                    catch (IOException iOException) {}
                }
                if (dataPointArray != null) {
                    int n4 = 0;
                    while (n4 < dataPointArray.length) {
                        this.addToHistory(dataPointArray[n4]);
                        ++n4;
                    }
                }
            }
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("   DpNode:adding poller ");
            }
            this.scalarPoller = snmpPoller;
            this.tablePoller = tablePoller;
            if (tablePoller != null) {
                object3 = this.oiList.getWildcardOIs();
                this.baseLength = object3[0].length();
            } else {
                this.baseLength = 0;
            }
            this.session = snmpSession;
        } else {
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("   DpNode:No Session to agent");
            }
            bl = false;
        }
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("   DpNode:completed Initializing node  " + dpPollingInstance.getHostname());
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("     Node : ");
        stringBuffer.append(this.id);
        stringBuffer.append(" Notify Object : ");
        stringBuffer.append(this.getNotifyObject().toString());
        stringBuffer.append(" armed :");
        stringBuffer.append(this.armed);
        return stringBuffer.toString();
    }

    protected String getNodeName() {
        return this.pollingInst.getHostname();
    }

    protected DpPollingDefinition getPollingDefinition() {
        return this.pollingInst.getPollingDefinition();
    }

    protected DpPollingInstance getPollingInstance() {
        return this.pollingInst;
    }

    protected int getSysUpTimeIndex() {
        return this.oiList.getSysUpTimeIndex();
    }

    protected void changeState(String string) {
        StandardDeviation standardDeviation;
        if (this.state.equals(string)) {
            return;
        }
        if (DpInterfaceImpl.trace_schedule) {
            DpInterfaceImpl.LogMessage("DpNode:changeState: old=" + this.state.toString() + ", new=" + string);
        }
        if ((standardDeviation = (StandardDeviation)this.states.get(string)) == null) {
            if (DpInterfaceImpl.trace_schedule) {
                DpInterfaceImpl.LogMessage("DpNode:  creating a new state for new name...");
            }
            standardDeviation = new StandardDeviation(20);
            this.states.put(string, standardDeviation);
        }
        this.sdev = standardDeviation;
        this.armed = false;
        int n = this.rows.size();
        int n2 = 0;
        while (n2 < n) {
            ((AbstractResult)this.rows.elementAt((int)n2)).armed = false;
            ++n2;
        }
        this.state = string;
    }

    protected boolean changeNotifyObject(NotifyObject notifyObject) {
        boolean bl = true;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpNode:changeNotifyObject");
        }
        this.armed = false;
        int n = this.rows.size();
        int n2 = 0;
        while (n2 < n) {
            ((AbstractResult)this.rows.elementAt((int)n2)).armed = false;
            ++n2;
        }
        if (this.armStuff == null) {
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("DpNode:changeNotifyObject:modifying node");
            }
            int n3 = notifyObject != null ? notifyObject.getPollingInterval() : this.pollingInst.getPollingDefinition().getPollingObjectDefinition().getNotifyObject().getPollingInterval();
            new PollingInterval(n3 * 1000);
            if (this.scalarPoller != null) {
                this.scalarPoller.getInterval().interval = n3 * 1000;
            }
            if (this.tablePoller != null) {
                this.tablePoller.getInterval().interval = n3 * 1000;
            }
        }
        return bl;
    }

    protected void stopPolling() {
        File file;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpNode:stopping polling");
        }
        if (this.scalarPoller != null) {
            this.session.remove((AbstractSnmpPoller)this.scalarPoller);
        }
        if (this.tablePoller != null) {
            this.session.remove((AbstractSnmpPoller)this.tablePoller);
        }
        PollingInterval pollingInterval = this.scalarPoller != null ? this.scalarPoller.getInterval() : this.tablePoller.getInterval();
        DpInterfaceImpl.pollerList.removePollerMonitor(pollingInterval, this.session);
        DpInterfaceImpl.deleteNode(this);
        int n = 0;
        while (n <= this.maxFiles) {
            file = new File(String.valueOf(this.fileName) + "." + n);
            if (file.exists()) {
                file.delete();
            }
            ++n;
        }
        file = null;
        this.isPolling = false;
    }

    protected void startPolling() {
        PollingInterval pollingInterval = this.scalarPoller != null ? this.scalarPoller.getInterval() : this.tablePoller.getInterval();
        DpInterfaceImpl.pollerList.addPollerMonitor(pollingInterval, this.session);
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpNode:starting polling table:\n" + this.tablePoller + " scalar:\n" + this.scalarPoller);
        }
        if (this.scalarPoller != null && this.tablePoller != null) {
            AbstractSnmpPoller[] abstractSnmpPollerArray = new AbstractSnmpPoller[]{this.scalarPoller, this.tablePoller};
            try {
                this.session.add(abstractSnmpPollerArray, (Object)this);
            }
            catch (Exception exception) {
                DpInterfaceImpl.LogMessage("DpNode:Add of array of pollers failed with exception : " + exception.toString());
            }
        } else {
            if (this.scalarPoller != null) {
                this.session.add((AbstractSnmpPoller)this.scalarPoller, (Object)this);
            }
            if (this.tablePoller != null) {
                this.session.add((AbstractSnmpPoller)this.tablePoller, (Object)this);
            }
        }
        this.isPolling = true;
    }

    protected void suspendPolling() {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpNode:suspending polling");
        }
        if (this.scalarPoller != null) {
            this.session.remove((AbstractSnmpPoller)this.scalarPoller);
        }
        if (this.tablePoller != null) {
            this.session.remove((AbstractSnmpPoller)this.tablePoller);
        }
        this.isPolling = false;
    }

    protected boolean nodeMatches(SnmpSession snmpSession) {
        return snmpSession == this.session;
    }

    protected Vector getRowIds() {
        Vector<String> vector = null;
        if (this.rows != null) {
            int n = this.rows.size();
            vector = new Vector<String>();
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(((AbstractResult)this.rows.elementAt((int)n2)).index);
                ++n2;
            }
        }
        return vector;
    }

    protected Object addRow(String string) {
        String string2 = string.substring(this.baseLength + 1);
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("New row, id:" + string + ", index:" + string2 + ", baselen:" + this.baseLength);
        }
        if (this.numExpressions == 1) {
            Result result = new Result(string, string2, Float.NEGATIVE_INFINITY);
            this.rows.addElement(result);
            return result;
        }
        MultiResult multiResult = new MultiResult(string, string2, this.numExpressions);
        this.rows.addElement(multiResult);
        return multiResult;
    }

    protected Object addRow(OID oID) {
        return this.addRow(oID.toString());
    }

    protected void removeRow(Object object) {
        if (object instanceof Result) {
            Result result = (Result)object;
            result.id = null;
            result.val = Float.NEGATIVE_INFINITY;
            this.rows.removeElement(object);
            return;
        }
        MultiResult multiResult = (MultiResult)object;
        multiResult.id = null;
        multiResult.vals = null;
        this.rows.removeElement(object);
    }

    public void saveScalarValues(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.oiList.getScalarIndexes();
        int n = this.oiList.getScalarOIcount();
        int n2 = 0;
        while (n2 < n) {
            this.oldValues[nArray[n2]] = objectArray[n2];
            this.newValues[nArray[n2]] = objectArray2[n2];
            ++n2;
        }
    }

    public void setTableValues(int n, Object[] objectArray, Object[] objectArray2) {
        int[] nArray = this.oiList.getWildcardIndexes();
        int n2 = this.oiList.getWildcardOIcount();
        int n3 = 0;
        while (n3 < n2) {
            this.oldValues[nArray[n3]] = objectArray[n3];
            this.newValues[nArray[n3]] = objectArray2[n3];
            ++n3;
        }
    }

    public void setResult(int n, Object object, float f) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpNode: result set to : " + f);
        }
        if (this.numExpressions == 1) {
            ((Result)object).val = f;
            return;
        }
        ((MultiResult)object).vals[n] = f;
    }

    public void clearResult(Object object, int n) {
        if (this.numExpressions == 1) {
            ((Result)object).val = Float.NEGATIVE_INFINITY;
            return;
        }
        ((MultiResult)object).vals[n] = Float.NEGATIVE_INFINITY;
    }

    public void clearResults(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Result)enumeration.nextElement()).val = Float.NEGATIVE_INFINITY;
        }
    }

    public boolean validResult(Object object) {
        return ((Result)object).val != Float.NEGATIVE_INFINITY;
    }

    public float getResult(Object object, int n) {
        if (this.numExpressions == 1) {
            return ((Result)object).val;
        }
        return ((MultiResult)object).vals[n];
    }

    public Vector getResults(Object object) {
        Vector<Float> vector = new Vector<Float>();
        int n = 0;
        while (n < this.numExpressions) {
            vector.addElement(new Float(((MultiResult)object).vals[n]));
            ++n;
        }
        return vector;
    }

    public String getRowId(Object object) {
        return ((AbstractResult)object).index;
    }

    protected float getAverage(Object object) {
        return ((AbstractResult)object).getSdev(this.state).getAverage();
    }

    protected boolean getArmedState(Object object) {
        return ((AbstractResult)object).getArmedState();
    }

    protected void changeArmedState(Object object) {
        ((AbstractResult)object).changeArmedState();
    }

    protected synchronized boolean autoCheck() {
        boolean bl = false;
        if (this.numValues >= 2L) {
            float f = this.getPreviousEntry() instanceof DataPoint ? ((DataPoint)this.getLatestEntry()).getValue() : ((Float)((MultiDataPoint)this.getLatestEntry()).getValues().elementAt(0)).floatValue();
            bl = f == Float.NEGATIVE_INFINITY ? false : this.autoCheck(f, this.sdev);
        }
        return bl;
    }

    protected synchronized boolean autoCheck(Object object) {
        boolean bl = false;
        if (this.numValues >= 2L) {
            StandardDeviation standardDeviation = ((AbstractResult)object).getSdev(this.state);
            this.armed = ((AbstractResult)object).getArmedState();
            float f = object instanceof Result ? ((Result)object).val : ((MultiResult)object).vals[0];
            bl = this.autoCheck(f, standardDeviation);
            if (bl) {
                ((AbstractResult)object).changeArmedState();
            }
        }
        return bl;
    }

    protected synchronized boolean autoCheck(float f, StandardDeviation standardDeviation) {
        boolean bl = false;
        if (f != Float.NEGATIVE_INFINITY) {
            float f2 = standardDeviation.calculate(f);
            float f3 = standardDeviation.getAverage();
            if (DpInterfaceImpl.trace_expression) {
                DpInterfaceImpl.LogMessage("DpNode:Autocheck: value:" + f + " average:" + f3 + " sdev:" + f2);
            }
            if (!Float.isNaN(f2)) {
                NotifyObject notifyObject = this.getNotifyObject();
                float f4 = f3 * DpInterfaceImpl.minValueVariationPercent;
                if (!this.armed) {
                    float f5 = notifyObject.getArmValue();
                    float f6 = f5 * f2;
                    if (f6 < f4) {
                        f6 = f4;
                    }
                    if (f > f3 + f6 || f < f3 - f6) {
                        if (DpInterfaceImpl.trace_expression) {
                            DpInterfaceImpl.LogMessage("armed initially. a+d=" + (f3 + f6) + " a-d=" + (f3 - f6) + " value=" + f);
                        }
                        bl = true;
                    }
                } else {
                    float f7 = notifyObject.getRearmValue();
                    float f8 = f7 * f2;
                    if (f8 < f4) {
                        f8 = f4;
                    }
                    if (f < f3 + f8 && f > f3 - f8) {
                        if (DpInterfaceImpl.trace_expression) {
                            DpInterfaceImpl.LogMessage("not armed initially. a+d=" + (f3 + f8) + " a-d=" + (f3 - f8) + " value=" + f);
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.armed = !this.armed;
                    this.poppedValue = (f - f3) / f3;
                }
            } else {
                bl = false;
            }
            if (DpInterfaceImpl.trace_expression) {
                DpInterfaceImpl.LogMessage("DpNode:auto evaluated - value:" + f + " average:" + f3 + " result:" + bl);
            }
        }
        if (bl && DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("++++Auto Check evaluated to true - armed=" + this.armed + " : " + standardDeviation.toString());
        }
        return bl;
    }

    protected float rateOfChange() {
        float f;
        if (this.numValues >= 2L) {
            float f2 = ((DataPoint)this.getPreviousEntry()).getValue();
            float f3 = ((DataPoint)this.getLatestEntry()).getValue();
            long l = this.getPreviousEntry().getDate();
            long l2 = this.getLatestEntry().getDate();
            long l3 = (l2 - l) / 1000L;
            if (l3 == 0L) {
                l3 = 1L;
            }
            f = (f3 - f2) / (float)l3;
        } else {
            f = 0.0f;
        }
        return f;
    }

    private void syncFileCounter(String string) {
        long l = 0L;
        int n = 0;
        while (n <= this.maxFiles) {
            File file = new File(String.valueOf(string) + "." + n);
            if (!file.exists() || file.lastModified() < l) break;
            l = file.lastModified();
            ++n;
        }
        this.currentFile = this.currentFile;
    }

    /*
     * Unable to fully structure code
     */
    private void cleanUpOldData(String var1_1, long var2_2) {
        var4_3 = null;
        var5_4 = null;
        try {
            var4_3 = new ObjectInputStream(new FileInputStream(var1_1));
            var5_4 = new ObjectOutputStream(new FileOutputStream(String.valueOf(this.fileName) + ".temp00"));
            while (true) {
                if ((var6_5 = (DataPoint)var4_3.readObject()).getDate() <= var2_2) {
                    continue;
                }
                var5_4.writeObject(var6_5);
            }
        }
        catch (Exception v0) {
            try {
                var4_3.close();
                var5_4.close();
                var7_6 = new File(String.valueOf(var1_1) + ".temp00");
                var7_6.renameTo(new File(var1_1));
            }
            catch (Exception v1) {}
            var7_7 = 0;
            var8_8 = 0;
            ** while (var8_8 < this.internalOffset)
        }
lbl-1000:
        // 1 sources

        {
            if (this.theDataPoints[var8_8].getDate() >= var2_2) {
                var7_7 = var8_8;
                break;
            }
            ++var8_8;
            continue;
        }
lbl28:
        // 2 sources

        if (var7_7 > 0) {
            var9_9 = 0;
            var11_10 = var7_7;
            while (var11_10 < this.internalOffset) {
                var10_11 = this.theDataPoints[var11_10];
                this.theDataPoints[var11_10] = this.theDataPoints[var9_9];
                this.theDataPoints[var9_9++] = var10_11;
                ++var11_10;
            }
            this.internalOffset -= var7_7;
        }
    }

    private Vector readFile(String string) {
        return this.readFile(string, null, 0L);
    }

    private Vector readFile(String string, String string2, long l) {
        long l2 = 0L;
        Vector<DataPoint> vector = new Vector<DataPoint>();
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(String.valueOf(string) + ".0"));
            int n = 0;
            int n2 = 0;
            while (true) {
                DataPoint dataPoint;
                try {
                    dataPoint = (DataPoint)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    if (++n > this.maxFiles) break;
                    objectInputStream.close();
                    objectInputStream = new ObjectInputStream(new FileInputStream(String.valueOf(string) + "." + n));
                    dataPoint = (DataPoint)objectInputStream.readObject();
                }
                if (string2 != null && !string2.equals(dataPoint.getID()) || l != 0L && dataPoint.getDate() < l) continue;
                if (l2 > dataPoint.getDate()) {
                    n2 = 0;
                    this.currentFile = n;
                }
                l2 = dataPoint.getDate();
                vector.insertElementAt(dataPoint, n2++);
            }
            objectInputStream.close();
        }
        catch (Exception exception) {}
        return vector;
    }

    private void saveData() {
        if (this.currentFile > this.maxFiles) {
            this.currentFile = 0;
            this.historyOverflowNotified = false;
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(String.valueOf(this.fileName) + "." + this.currentFile));
            int n = 0;
            while (n < this.historySize) {
                objectOutputStream.writeObject(this.theDataPoints[n]);
                ++n;
            }
            objectOutputStream.close();
        }
        catch (Exception exception) {}
        ++this.currentFile;
        if ((float)this.currentFile >= DpInterfaceImpl.historyThreshold * (float)this.maxFiles && !this.historyOverflowNotified) {
            this.historyOverflowNotified = true;
            if (DpInterfaceImpl.sendHistoryWithEvent) {
                DpInterfaceImpl.addNotification(this);
            } else {
                DpInterfaceImpl.addNotification(new HistoryEvent(this.getLatestEntry().getDate(), this.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), this.getNodeName()));
            }
        }
        if (this.newHistorySize != 0) {
            if (this.newHistorySize > this.theDataPoints.length) {
                DataPoint[] dataPointArray = new DataPoint[this.newHistorySize];
                int n = 0;
                while (n < this.historySize) {
                    dataPointArray[n] = this.theDataPoints[n];
                    ++n;
                }
                int n2 = this.historySize;
                while (n2 < this.newHistorySize) {
                    this.theDataPoints[n2] = new DataPoint();
                    ++n2;
                }
                this.theDataPoints = dataPointArray;
            }
            this.historySize = this.newHistorySize;
            this.newHistorySize = 0;
        }
    }

    protected synchronized Vector getHistory(long l) {
        return this.getHistory(null, l);
    }

    protected synchronized Vector getHistory(String string, long l) {
        Vector vector = this.readFile(this.fileName, string, l);
        int n = 0;
        while (n < this.internalOffset) {
            if (this.theDataPoints[n].getDate() > l) {
                vector.addElement(this.theDataPoints[n]);
            }
            ++n;
        }
        return vector;
    }

    protected synchronized void clearHistory(long l) {
        long l2 = System.currentTimeMillis();
        int n = 0;
        if (this.currentFile > this.maxFiles) {
            this.currentFile = 0;
            this.historyOverflowNotified = false;
        }
        int n2 = this.currentFile;
        do {
            File file;
            if ((file = new File(String.valueOf(this.fileName) + "." + n2)).exists() && file.lastModified() < l) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            } else if (file.lastModified() > l && file.lastModified() < l2) {
                l2 = file.lastModified();
                n = n2;
            }
            if (++n2 <= this.maxFiles) continue;
            n2 = 0;
        } while (n2 != this.currentFile);
        this.cleanUpOldData(String.valueOf(this.fileName) + "." + n, l);
    }

    private void reloadHistory() {
        boolean bl = "AUTO".equals(this.getNotifyObject().getArmOp());
        Vector vector = this.readFile(this.fileName);
        if (vector != null && vector.size() > 0) {
            int n;
            int n2;
            int n3 = this.theDataPoints.length;
            if (vector.size() >= n3) {
                n2 = n3;
                n = vector.size() - n3;
            } else {
                n2 = vector.size();
                n = 0;
            }
            if (vector.elementAt(0) instanceof DataPoint) {
                int n4 = 0;
                while (n4 < n2) {
                    this.theDataPoints[n4].setDate(((DataPoint)vector.elementAt(n + n4)).getDate());
                    ((DataPoint)this.theDataPoints[n4]).setValue(((DataPoint)vector.elementAt(n + n4)).getValue());
                    if (bl) {
                        this.autoCheck();
                    }
                    ++n4;
                }
                return;
            }
            int n5 = 0;
            while (n5 < n2) {
                this.theDataPoints[n5].setDate(((DataPoint)vector.elementAt(n + n5)).getDate());
                ((MultiDataPoint)this.theDataPoints[n5]).setValues(((MultiDataPoint)vector.elementAt(n + n5)).getValues());
                if (bl) {
                    this.autoCheck();
                }
                ++n5;
            }
            return;
        }
        DpInterfaceImpl.LogMessage("DpNode:Malformed history : " + this.fileName);
    }

    protected GenericDataPoint getPreviousEntry() {
        if (this.internalOffset == 0) {
            return this.theDataPoints[this.historySize - 2];
        }
        if (this.internalOffset == 1) {
            return this.theDataPoints[this.historySize - 1];
        }
        return this.theDataPoints[this.internalOffset - 2];
    }

    protected GenericDataPoint getLatestEntry() {
        if (this.internalOffset == 0) {
            return this.theDataPoints[this.historySize - 1];
        }
        return this.theDataPoints[this.internalOffset - 1];
    }

    protected void addToHistory(long l, Vector vector) {
        int n = vector.size();
        if (this.numExpressions == 1) {
            int n2 = 0;
            while (n2 < n) {
                this.addToHistory(l, ((Result)vector.elementAt((int)n2)).index, new Float(((Result)vector.elementAt((int)n2)).val));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            this.addToHistory(l, ((MultiResult)vector.elementAt((int)n3)).index, ((MultiResult)vector.elementAt((int)n3)).vals);
            ++n3;
        }
    }

    protected void addToHistory(GenericDataPoint genericDataPoint) {
        if (genericDataPoint instanceof DataPoint) {
            DataPoint dataPoint = (DataPoint)genericDataPoint;
            this.addToHistory(dataPoint.getDate(), dataPoint.getID(), new Float(dataPoint.getValue()));
            return;
        }
        MultiDataPoint multiDataPoint = (MultiDataPoint)genericDataPoint;
        this.addToHistory(multiDataPoint.getDate(), multiDataPoint.getID(), multiDataPoint.getValues());
    }

    protected void addToHistory(long l, String string, float[] fArray) {
        DpInterfaceImpl.LogMessage("logging a multi-value data point by array");
        Vector<Float> vector = new Vector<Float>(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            vector.addElement(new Float(fArray[n]));
            ++n;
        }
        this.addToHistory(l, string, vector);
    }

    protected synchronized void addToHistory(long l, String string, Object object) {
        if (string == null && this.defaultID != null) {
            string = this.defaultID;
        }
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DataPoint : " + this.fileName + "     time:" + l + ", id:" + string + ", value:" + object);
        }
        ++this.numValues;
        if (object instanceof Float && ((Float)object).floatValue() == Float.NEGATIVE_INFINITY || object instanceof Vector && object == null) {
            ++this.invalidValues;
            ++this.consecutiveInvalidValues;
        } else {
            this.consecutiveInvalidValues = 0L;
        }
        if (this.consecutiveInvalidValues > (long)DpInterfaceImpl.maxConsecutiveFailures) {
            if (DpInterfaceImpl.NodeFailure(this.getIpAddress())) {
                this.stopPolling();
            } else {
                this.consecutiveInvalidValues = 0L;
            }
        }
        this.theDataPoints[this.internalOffset].setDate(l);
        if (string != null) {
            this.theDataPoints[this.internalOffset].setID(string);
        }
        if (object instanceof Float && this.theDataPoints[0] instanceof DataPoint) {
            ((DataPoint)this.theDataPoints[this.internalOffset]).setValue(((Float)object).floatValue());
        } else {
            ((MultiDataPoint)this.theDataPoints[this.internalOffset]).setValues((Vector)object);
        }
        ++this.internalOffset;
        if (this.internalOffset >= this.historySize) {
            this.internalOffset = 0;
            if (!DpInterfaceImpl.writeToFile) {
                this.historyOverflowNotified = false;
            }
        }
        if (DpInterfaceImpl.writeToFile) {
            if (this.internalOffset == 0) {
                long l2 = System.currentTimeMillis();
                this.saveData();
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("Saving data for " + this.session.getIpAddress() + " took " + (System.currentTimeMillis() - l2) + " milliseconds.");
                    return;
                }
            }
        } else if ((float)this.internalOffset > DpInterfaceImpl.historyThreshold * (float)this.historySize && !this.historyOverflowNotified) {
            this.historyOverflowNotified = true;
            if (DpInterfaceImpl.sendHistoryWithEvent) {
                DpInterfaceImpl.addNotification(this);
                return;
            }
            DpInterfaceImpl.addNotification(new HistoryEvent(this.theDataPoints[this.internalOffset - 1].getDate(), this.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), this.getNodeName()));
        }
    }
}

